//
//  MCDurationPickerCell.h
//  MCApplication
//
//  Created by Michael Clark on 04/04/05.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MCPickerCommon.h"

typedef enum { MCDurationPickerMinutesSecondsMode, MCDurationPickerHoursMinutesMode, MCDurationPickerDaysMode } MCDurationPickerMode;


typedef struct __MCDurationPickerCellFlags {
	NSUInteger drawsBackground:1;
	NSUInteger drawsGloss:1;
	NSUInteger drawsText:1; // For debugging more than anything
	
	NSUInteger reservedTimePickerCell:29;
} _MCDurationPickerCellFlags;



// Defines for the bindings - they define indices into the various C style areas for keeping track of the necessary things
#define   MCDurationPickerBindingCount        1
#define   MCDurationPickerActiveBinding    0x00
//... define more as necessary




@interface MCDurationPickerCell : NSActionCell {
	_MCDurationPickerCellFlags        _flags;
	
	NSInteger                               __controlSize;
	MCPickerState                     __state;
	BOOL                              __active;
	BOOL                              __hasInvalidSelection;
	MCDurationPickerMode              _mode;
	
	NSInteger                 _seconds;
	
	NSString*           _windowOneString[2];
	NSInteger                 _windowOneCounters[2];
	
	NSString*           _windowTwoString[2];
	NSInteger                 _windowTwoCounters[2];
	
	NSRect        _cellFrame;
	
	// Bindings support
	id          _observedObjects[MCDurationPickerBindingCount];
	NSString*   _observedKeyPaths[MCDurationPickerBindingCount];	
	
	BOOL   _mouseDown;
	NSInteger    _pressedImageIndex;
	NSInteger    _inRect; // 0 - window 1 square 1, 1 - window 1 square 2, 2 - window 2 square 1, 3 - window 2 square 2
	
	BOOL _colonOn;
	
	NSDictionary* attributes;
}

- (void)toggleGloss;
- (void)toggleText;


- (BOOL)drawsBackground;
- (void)setDrawsBackground: (BOOL)flag;

- (BOOL)drawsGloss;
- (void)setDrawsGloss: (BOOL)flag;

- (MCDurationPickerMode)durationMode;
- (void)setDurationMode:(MCDurationPickerMode)aMode;

- (MCPickerState)state;
- (void)setState:(MCPickerState)aState;

- (BOOL)active;
- (void)setActive:(BOOL)flag;

- (NSDictionary *)attributes;
- (void)setAttributes:(NSDictionary *)anAttributes;
@end
